/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record FallLocation(String id) {
    public static final FallLocation GENERIC = new FallLocation("generic");
    public static final FallLocation LADDER = new FallLocation("ladder");
    public static final FallLocation VINES = new FallLocation("vines");
    public static final FallLocation WEEPING_VINES = new FallLocation("weeping_vines");
    public static final FallLocation TWISTING_VINES = new FallLocation("twisting_vines");
    public static final FallLocation SCAFFOLDING = new FallLocation("scaffolding");
    public static final FallLocation OTHER_CLIMBABLE = new FallLocation("other_climbable");
    public static final FallLocation WATER = new FallLocation("water");

    public static FallLocation blockToFallLocation(BlockState p_289530_) {
        if (p_289530_.is(Blocks.LADDER) || p_289530_.is(BlockTags.TRAPDOORS)) {
            return LADDER;
        }
        if (p_289530_.is(Blocks.VINE)) {
            return VINES;
        }
        if (p_289530_.is(Blocks.WEEPING_VINES) || p_289530_.is(Blocks.WEEPING_VINES_PLANT)) {
            return WEEPING_VINES;
        }
        if (p_289530_.is(Blocks.TWISTING_VINES) || p_289530_.is(Blocks.TWISTING_VINES_PLANT)) {
            return TWISTING_VINES;
        }
        if (p_289530_.is(Blocks.SCAFFOLDING)) {
            return SCAFFOLDING;
        }
        return OTHER_CLIMBABLE;
    }

    @Nullable
    public static FallLocation getCurrentFallLocation(LivingEntity p_289566_) {
        Optional<BlockPos> $$1 = p_289566_.getLastClimbablePos();
        if ($$1.isPresent()) {
            BlockState $$2 = p_289566_.level().getBlockState($$1.get());
            return FallLocation.blockToFallLocation($$2);
        }
        if (p_289566_.isInWater()) {
            return WATER;
        }
        return null;
    }

    public String languageKey() {
        return "death.fell.accident." + this.id;
    }
}

